/************************************************************************
 * \file: atrace.h
 *
 * \version: $Id: trace_atrace.h,v 1.2 2012/05/28 10:25:01 jayanth.mc Exp $
 *
 * This file exports application interface by Trace component.
 *
 * \component: Gen2 Trace
 *
 * \author B. Das         Bhaskar.Das(o)in.bosch.com
 *         Sakthivelu S.  Sakthivelu.S(o)in.bosch.com
 *\ Modified: Arun V      (Porting to Linux)
 *\ Modified: Arun V      (To be usable in TKernel Environment)
 * \copyright: (c) 2003 - 2009 ADIT
 *
 ***********************************************************************/
#ifndef __TRACE_H__
#define __TRACE_H__


#include "adit_typedef.h"
#include "adit_trace.h"
#include "trace_interface.h"

#ifdef __cplusplus
IMPORT "C" {
#endif

typedef S32   ER ;

#ifndef E_OK
 #define E_OK  0
#endif 

#ifndef E_FAIL
#define E_FAIL (-1)
#endif

#ifndef E_ABORT
#define E_ABORT (-2)
#endif

#define TR_COMPID(x)          (((x) >> 8) & 0xFF)
#define TR_CLASID(x)          ((x) & 0xFF)

#define TRACE_TraceOut        ("TR_core_uwTraceOut")
#define TRACE_IsClassSelected ("TR_core_bIsClassSelected")
#define TRACE_RegChan         ("TR_chan_acess_bRegChan")
#define TRACE_UnRegChan       ("TR_chan_acess_bUnRegChan")
#define TRACE_BinOutput       ("TR_core_uwTraceBinOutput")

  /* Trace Channel ID */
typedef S16 TRACE_chnl_id;

/* Trace class level status */
typedef TR_tenTraceLevel TRACE_level;

/* PRQA: Lint Message 46: Fix from U32 to U8 is done as part of a hot fix */
/*lint -save -e46 */
/* Trace & Proxy Class/Level configuration */
/* SWGII-6172(SWGII-6163): Trace levels are stored outside the allocated memory*/
/* Fix:- change the below strcuture members from U32 :4 to U8 :4 (agv2kor)*/
typedef struct
{
  U8 trc_lvl :4;                           /* Enable level for Trace */
  U8 pxy_lvl :4;                           /* Enable level for Proxy */
}TRACE_lvl;

/*lint -restore */

typedef struct
{
  U16         max_clas;                    /* Max Class used by each comp          */
  TRACE_lvl*  lvl;                         /* Pointer to active lvl for each Class */
}TRACE_comp_inf;

typedef struct _TRACE_class_cnfg_sh
{
  TRACE_clas_ena_stat lvl_filter:32;         /* EnableAll = level, DisableAll = 0xff */
}TRACE_class_cnfg_sh;

typedef struct _TRACE_class_cnfg
{
  TRACE_class_cnfg_sh* sh;
  TRACE_comp_inf comp[TR_MAX_COMP_COUNT];       /* Class/Level info for all comp  */
}TRACE_class_cnfg;

typedef struct _TRACE_EC
{
  U32 cls_lvl_cfg      : 1;
  U32 cls_noexst       : 1;
  U32 invalid_msg      : 1;
  U32 invalid_msg_len  : 1;
  U32 lvl_disabled     : 1;
  U32 q_wait_flg       : 1;
  U32 invalid_sz       : 1;
  U32 cre_timestamp    : 1;
  U32 invalid_chnl     : 1;
  U32 chnl_alrdy_reg   : 1;
  U32 invalid_sta_buf  : 1;
  U32 invalid_callback : 1;
  U32 no_media         : 1;
  U32 cnfg_failed      : 1;
}TRACE_EC;

/* Specific error code */
typedef union
{
  S32          error_code;
  TRACE_EC     ec;
}TRACE_ext_err_code;

/* Normal Trace message */
typedef struct
{
  U32                  len;                /* Message length                 */
  U32                  clas;               /* Trace class of message         */
  TRACE_level          level;              /* Trace level of message         */
  S8*                  msg;                /* User buffer                    */
}TRACE_msg;

/* Trace Large Binary Message */
typedef struct
{
  U32                  len;                /* Message length                 */
  U32                  clas;               /* Trace class of message         */
  TRACE_level          level;              /* Trace level of message         */
  S8*                  msg;                /* User buffer                    */
  U32                  sock_id;            /* Socket ID                      */
}TRACE_lb_msg;

/* Trace class/level status */
typedef struct
{
  U32                  clas;               /* Trace class of message         */
  TRACE_level          level;              /* Trace level of message         */
  TRACE_clas_ena_stat* stat;               /* Enable/disable status          */
}TRACE_isactive;

/* Trace callback info */
typedef struct
{
  TRACE_chnl_id   chnl_id;                 /* Channel ID                     */
  TRACE_CALLBACK  func;                    /* Callback function              */
}TRACE_callbk;

/* Trace configuration data */
typedef struct
{
 TRACE_class_cnfg** c_cnfg;                /* Pointer to shared memory */
}TRACE_cfg_data;

typedef struct
{
  U8* p_shmem;               /*Pointer to a shared memory strucutre*/
}TRACE_sh_mem;

typedef struct _TRACE_be_func
{  
  ER (*exit_fn)(S32);
}TRACE_be_func;

/* Trace Backend info */
typedef struct _TRACE_backend
{
  TRACE_be_func         fntbl;
  struct _TRACE_mgr**   mgr;
}TRACE_backend;

IMPORT ER TRACE_get_sh_cnfg(TRACE_cfg_data* msg);

#ifdef __cplusplus
}
#endif
#endif
